/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.comp.PopupWindow;
import DE.siemens.ad.logo.dialog.CompactBlockSelectionPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.ConnectConnectorWithAction;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectInConnectorWithAction
extends ConnectConnectorWithAction {
    public ConnectInConnectorWithAction() {
        this.putValue("Name", "edit.connectInConnectorWith");
        this.putValue("textKey", "edit.connectInConnectorWith");
    }

    public boolean doIt() {
        this.fLogoDrawing = (LogoDrawing)this.getDrawingView().drawing();
        Vector selection = this.getDrawingView().selection();
        if (selection.isEmpty() || selection.size() > 1 || !(selection.elementAt(0) instanceof InputIfcFigure)) {
            return false;
        }
        this.fInputFigure = (InputIfcFigure)selection.elementAt(0);
        InBlockConnector inBlockConnector = (InBlockConnector)this.fInputFigure.getBlockConnector();
        if (!inBlockConnector.isConnectable()) {
            return false;
        }
        WiringDiagram wiringDiagram = this.fLogoDrawing.getWiringDiagram();
        Vector blocks = wiringDiagram.getBlocks();
        Vector<Block> connectableBlocks = new Vector<Block>();
        Enumeration e = blocks.elements();
        Block block = null;
        while (e.hasMoreElements()) {
            OutBlockConnector outBlockConnector;
            block = (Block)e.nextElement();
            if (inBlockConnector.getOwner() == block || inBlockConnector.getOwner() instanceof DeputyBlock && ((DeputyBlock)inBlockConnector.getOwner()).getParent() == block || block.getOutConnectorCount() <= 0 || !this.connectorTypesCompatible(outBlockConnector = block.getOutConnector(0), inBlockConnector) || !wiringDiagram.canConnectWithoutRecursion(outBlockConnector, inBlockConnector) || !outBlockConnector.isConnectable()) continue;
            connectableBlocks.add(block);
        }
        this.fCompactBlockSelectionPanel = new CompactBlockSelectionPanel(connectableBlocks, this.fLogoDrawing);
        this.fCompactBlockSelectionPanel.setRemidInfo(Language.getString("dialog.selectOutConnector.remindInfo", "Select an out connector to connect"));
        this.fCompactBlockSelectionPanel.setConnectorsVisible(false);
        ConnectConnectorWithAction.DoubleClickHandler doubleClickHandler = new ConnectConnectorWithAction.DoubleClickHandler();
        this.fCompactBlockSelectionPanel.getBlockList().addMouseListener(doubleClickHandler);
        this.fPopupWindow = new PopupWindow(this.getOwner().getWindow());
        this.fPopupWindow.addPopupWindowListener(this);
        Point popupPosition = this.fInputFigure.displayBox().getLocation();
        popupPosition.translate(35, 10);
        popupPosition = this.getDrawingView().getZoomManager().convertModelToDisplayCoordinates(popupPosition);
        this.fPopupWindow.getContentPane().add(this.fCompactBlockSelectionPanel);
        this.fPopupWindow.show(this.getDrawingView(), new Rectangle(popupPosition, new Dimension(200, 200)));
        return true;
    }

    public void popupWindowApproved(PopupWindow.PopupWindowEvent popupEvent) {
        Block selectedBlock = this.fCompactBlockSelectionPanel.getSelectedBlock();
        if (selectedBlock == null) {
            return;
        }
        BlockFigure predecessorBlock = this.fLogoDrawing.getBlockFigure(selectedBlock);
        this.fOutputFigure = predecessorBlock.getOutputIfcFigure(selectedBlock.getOutConnector(0));
        this.createAndInsertConnection(this.fOutputFigure, this.fInputFigure);
    }
}

